//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "CharacterClass.h"
#include "PlayerUnit.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
#define MAX_ACTIONS 50
TControlForm *ControlForm;
extern CharacterNode CharListHead;
ActionDefNodeP actdefs[MAX_ACTIONS];
int nSelAction = -1;
int nSelRep1 = -1;
int nSelRep2 = -1;
unsigned char InvChgMode = 0;
//---------------------------------------------------------------------------
__fastcall TControlForm::TControlForm(TComponent* Owner)
    : TForm(Owner)
{
    ActiveCharacter = NULL;
}

//---------------------------------------------------------------------------
void TControlForm::ResetCharactersList()
{
    CharacterNode cn;
/*
    if(attTree)
        DelAttitudeTree(&attTree);
*/
    ItemObj = NULL;
    Rep1ItemObj = NULL;
    Rep2ItemObj = NULL;
    SelObjective->Items->Clear();
    for(cn = CharListHead; cn != NULL ; cn = cn->next)
    {
        if(cn->ch.BEStuff.IsDead())
            SelObjective->Items->Add(AnsiString(cn->ch.szName)+" <dead>");
        else
            if(ActiveCharacter != &(cn->ch))
                SelObjective->Items->Add(cn->ch.szName);
            else
                SelObjective->Items->Add(AnsiString(cn->ch.szName)+" <self>");
    }

    Rep1Obj->Items->Clear();
    for(cn = CharListHead; cn != NULL ; cn = cn->next)
    {
        if(cn->ch.BEStuff.IsDead())
            Rep1Obj->Items->Add(AnsiString(cn->ch.szName)+" <dead>");
        else
            if(ActiveCharacter != &(cn->ch))
                Rep1Obj->Items->Add(cn->ch.szName);
            else
                Rep1Obj->Items->Add(AnsiString(cn->ch.szName)+" <self>");
    }


    Rep2Obj->Items->Clear();
    for(cn = CharListHead; cn != NULL ; cn = cn->next)
    {
        if(cn->ch.BEStuff.IsDead())
            Rep2Obj->Items->Add(AnsiString(cn->ch.szName)+" <dead>");
        else
            if(ActiveCharacter != &(cn->ch))
                Rep2Obj->Items->Add(cn->ch.szName);
            else
                Rep2Obj->Items->Add(AnsiString(cn->ch.szName)+" <self>");
    }
    /*
    SelObjective->ItemIndex = 0;
    SelObjectiveChange(NULL);*/
}

//---------------------------------------------------------------------------
void TControlForm::ResetInventory()
{
	InventoryItem *iip;
    SelItem->Clear();
    if(ReferTo != NULL)
    {
        for(iip = ReferTo->InventoryHead ; iip != NULL ; iip = iip->next)
            SelItem->Items->Add(AnsiString((int)iip->ItemID)+" - "+
                AnsiString((char*)iip->Descr) );
    }
}

//---------------------------------------------------------------------------
void TControlForm::ResetRep1Inventory()
{
	InventoryItem *iip;
    Rep1Item->Clear();
    if(Rep1Objective != NULL)
    {
        for(iip = Rep1Objective->InventoryHead ; iip != NULL ; iip = iip->next)
            Rep1Item->Items->Add(AnsiString((int)iip->ItemID)+" - "+
                AnsiString((char*)iip->Descr) );
    }
}

//---------------------------------------------------------------------------
void TControlForm::ResetRep2Inventory()
{
	InventoryItem *iip;
    Rep2Item->Clear();
    if(Rep2Objective != NULL)
    {
        for(iip = Rep2Objective->InventoryHead ; iip != NULL ; iip = iip->next)
            Rep2Item->Items->Add(AnsiString((int)iip->ItemID)+" - "+
                AnsiString((char*)iip->Descr) );
    }
}

//---------------------------------------------------------------------------
void TControlForm::ResetActionsList()
{
    int i, nActNodesNo;

    nActNodesNo = FillBufferWithActionPtrs(actdefs,MAX_ACTIONS);
    if(!nActNodesNo)
        return;

    SelAction->Clear();
    SelAction->ItemIndex = 0;
    for(i = 0; i < nActNodesNo ; i++ )
        if(actdefs[i] && actdefs[i]->ActionID != 0)
        {
            SelAction->Items->Add((char*)actdefs[i]->Verb);
        }
    //reminder: exclude _Type == VERBAL from the future verbal lists
    SelRep1->Clear();
    SelRep1->ItemIndex = 0;
    for(i = 0; i < nActNodesNo ; i++ )
        if(actdefs[i] && actdefs[i]->ActionID != 0)
            if(actdefs[i]->_Type != VERBAL)
                SelRep1->Items->Add((char*)actdefs[i]->Verb);
            else
                SelRep1->Items->Add(AnsiString((char*)actdefs[i]->Verb) + " <not supported>");

    SelRep2->Clear();
    SelRep2->ItemIndex = 0;
    for(i = 0; i < nActNodesNo ; i++ )
        if(actdefs[i]) //&& actdefs[i]->_Type != VERBAL)
            if(actdefs[i]->_Type != VERBAL)
                SelRep2->Items->Add((char*)actdefs[i]->Verb);
            else
                SelRep2->Items->Add(AnsiString((char*)actdefs[i]->Verb) + " <not supported>");
}

//---------------------------------------------------------------------------
void __fastcall TControlForm::SelObjectiveChange(TObject *Sender)
{
    ReferTo = GetCharacter((int)SelObjective->ItemIndex);
    ResetInventory();
}

//---------------------------------------------------------------------------
void __fastcall TControlForm::FormActivate(TObject *Sender)
{
    ReferTo = NULL;
    Rep1Objective = NULL;
    Rep2Objective = NULL;
    ResetCharactersList();
    ResetInventory();
    ResetRep1Inventory();
    ResetRep2Inventory();
}

//---------------------------------------------------------------------------
void __fastcall TControlForm::FormCreate(TObject *Sender)
{
    ActiveCharacter = NULL;
    ResetActionsList();
}

//---------------------------------------------------------------------------
void __fastcall TControlForm::SelActionChange(TObject *Sender)
{
    nSelAction = SelAction->ItemIndex + 1;//because 0 is reserved
    if(actdefs[nSelAction]->_Type == VERBAL)
    {
        V1ContLbl->Visible = true;
        SelRep1->Visible = true;
        SelRep2->Visible = true;
        Rep1Obj->Visible = true;
        Rep2Obj->Visible = true;
        Rep1Item->Visible = true;
        Rep2Item->Visible = true;
    }
    else
    {
        V1ContLbl->Visible = false;
        SelRep1->Visible = false;
        SelRep2->Visible = false;
        Rep1Obj->Visible = false;
        Rep2Obj->Visible = false;
        Rep1Item->Visible = false;
        Rep2Item->Visible = false;
    }
    Update();
}

//---------------------------------------------------------------------------
void __fastcall TControlForm::GoForItBtnClick(TObject *Sender)
{
    Action *newAct,*Rep;

    if((nSelAction > -1) && (ReferTo != NULL) && (actdefs[nSelAction] != NULL))
    {
        newAct = CreateAction(actdefs[nSelAction]->ActionID);
        if(newAct != NULL)
        {
            if(nSelRep1 > -1 && Rep1Item->Visible)
            {
                Rep = CreateAction(actdefs[nSelRep1]->ActionID);
                if(Rep != NULL)
                {
                    if(Rep1ItemObj == NULL)
                        Rep->InitTargets(
                            ActiveCharacter->BEStuff.GetCoreAddress(),
                            Rep1Objective->BEStuff.GetCoreAddress());
                    else
                        Rep->InitTargets(
                            ActiveCharacter->BEStuff.GetCoreAddress(),
                            Rep1Objective->BEStuff.GetCoreAddress(),
                            &(Rep1ItemObj->BEStuff));
                    newAct->SetReported1(Rep);
                }
                GlobalFree((HGLOBAL)Rep);
            }

            if(nSelRep2 > -1 && Rep2Item->Visible)
            {
                Rep = CreateAction(actdefs[nSelRep2]->ActionID);
                if(Rep != NULL)
                {
                    if(Rep2ItemObj == NULL)
                        Rep->InitTargets(
                            ActiveCharacter->BEStuff.GetCoreAddress(),
                            Rep2Objective->BEStuff.GetCoreAddress());
                    else
                        Rep->InitTargets(
                            ActiveCharacter->BEStuff.GetCoreAddress(),
                            Rep2Objective->BEStuff.GetCoreAddress(),
                            &(Rep2ItemObj->BEStuff));
                    newAct->SetReported2(Rep);
                }
                GlobalFree((HGLOBAL)Rep);
            }

            newAct->SkipChecks = TRUE;
            if(ItemObj == NULL)
                newAct->InitTargets(
                    ActiveCharacter->BEStuff.GetCoreAddress(),
                    ReferTo->BEStuff.GetCoreAddress());
            else
                newAct->InitTargets(
                    ActiveCharacter->BEStuff.GetCoreAddress(),
                    ReferTo->BEStuff.GetCoreAddress(),
                    &(ItemObj->BEStuff));
            //UNSURPASSED_IMPORTANCE should override every possible importance
            ActiveCharacter->BEStuff.AdoptStrategyFromOneAction(
                newAct,UNSURPASSED_IMPORTANCE);
            GlobalFree((HGLOBAL)newAct);
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TControlForm::SelItemChange(TObject *Sender)
{
    if(ReferTo == NULL)
        ItemObj = NULL;
    else
        ItemObj = ReferTo->GetItem((ID)(SelItem->ItemIndex + 1));
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::SelRep1Change(TObject *Sender)
{
    nSelRep1 = SelRep1->ItemIndex + 1;//because 0 is reserved
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::SelRep2Change(TObject *Sender)
{
    nSelRep2 = SelRep2->ItemIndex;
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::Rep1ObjChange(TObject *Sender)
{
    Rep1Objective = GetCharacter((int)Rep1Obj->ItemIndex);
    ResetRep1Inventory();
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::Rep2ObjChange(TObject *Sender)
{
    Rep2Objective = GetCharacter((int)Rep2Obj->ItemIndex);
    ResetRep2Inventory();
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::DoNothingBtnClick(TObject *Sender)
{
    ActiveCharacter->BEStuff.CurrentStrategy.End();    
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::Rep1ItemChange(TObject *Sender)
{
    if(Rep1Objective == NULL)
        Rep1ItemObj = NULL;
    else
        Rep1ItemObj = ReferTo->GetItem((ID)(Rep1Item->ItemIndex + 1));
}
//---------------------------------------------------------------------------
void __fastcall TControlForm::Rep2ItemChange(TObject *Sender)
{
    if(Rep2Objective == NULL)
        Rep2ItemObj = NULL;
    else
        Rep2ItemObj = ReferTo->GetItem((ID)(Rep2Item->ItemIndex + 1));
}
//---------------------------------------------------------------------------
